package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Codrac_FL_door extends FrontDoor
{
	public Codrac_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Codrac front left door";

		value = 270;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );
		
		int gotWindow;
		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.codrac:0x00000112r, "FL window", actcolor, optical, power );
			gotWindow++;
		} else
		{
			if ( optical >= random() )
			{
				addPart( cars.cat_02.codrac:0x00000112r, "FL window", actcolor, optical, power );
				gotWindow++;
			}
		}
		
		if(gotWindow) //Don't generate mirrors when window is missing - they attach to door now
		{
			// parts that have multiple appearance //
			if ( optical <= 1.0 )
			{
				if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000117r, "L mirror", actcolor, optical, power );
			} else
			{
				float part_random = random();
				if ( part_random >= 0.66667 ) addPart( cars.cat_02.codrac:0x00000132r, "L mirror 3", actcolor, optical, power ); else
				if ( part_random >= 0.33333 ) addPart( cars.cat_02.codrac:0x0000012Cr, "L mirror 2", actcolor, optical, power ); else
				addPart( cars.cat_02.codrac:0x00000117r, "L mirror", actcolor, optical, power );
			}
		}
	}
}
